<?php
session_start();

// Verificar si el usuario está logueado y tiene permisos para ver esta página
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Conectar a la base de datos
require_once 'conexiones/conexion.php';

// Obtener los tipos de tickets registrados
$stmt = $pdo->prepare("SELECT id, nombre FROM ticket_tipo");
$stmt->execute();
$tipos_tickets = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Procesar la acción de agregar un nuevo tipo de ticket
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_ticket_type'])) {
    $nombre = $_POST['nombre'];

    // Insertar el nuevo tipo de ticket en la base de datos
    $stmt = $pdo->prepare("INSERT INTO ticket_tipo (nombre) VALUES (?)");
    $stmt->execute([$nombre]);

    header('Location: gestion_tipos_tickets.php');
    exit;
}

// Procesar la acción de editar un tipo de ticket
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_ticket_type'])) {
    $ticket_id = $_POST['ticket_id'];
    $nombre = $_POST['nombre'];

    // Actualizar el tipo de ticket en la base de datos
    $stmt = $pdo->prepare("UPDATE ticket_tipo SET nombre = ? WHERE id = ?");
    $stmt->execute([$nombre, $ticket_id]);

    header('Location: gestion_tipos_tickets.php');
    exit;
}

// Procesar la acción de eliminar un tipo de ticket
if (isset($_GET['delete'])) {
    $ticket_id = $_GET['delete'];

    // Eliminar el tipo de ticket de la base de datos
    $stmt = $pdo->prepare("DELETE FROM ticket_tipo WHERE id = ?");
    $stmt->execute([$ticket_id]);

    header('Location: gestion_tipos_tickets.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Tipos de Tickets</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include "menuajuste.php"; ?>

    <div class="content">
        <h1 class="text-center mb-4">Gestión de Tipos de Tickets</h1>

        <!-- Formulario para agregar nuevo tipo de ticket -->
        <div class="mb-4">
            <h3>Agregar Nuevo Tipo de Ticket</h3>
            <form action="gestion_tipos_tickets.php" method="POST">
                <div class="mb-3">
                    <label for="nombre" class="form-label">Nombre</label>
                    <input type="text" class="form-control" id="nombre" name="nombre" required>
                </div>
                <button type="submit" class="btn btn-primary" name="add_ticket_type">Agregar Tipo de Ticket</button>
            </form>
        </div>

        <!-- Tabla de tipos de tickets -->
        <h3>Tipos de Tickets Registrados</h3>
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($tipos_tickets as $tipo): ?>
                    <tr>
                        <td><?= htmlspecialchars($tipo['nombre']) ?></td>
                        <td>
                            <!-- Botón para abrir el modal de edición -->
                            <button 
                                class="btn btn-warning btn-sm" 
                                onclick="openEditModal(<?= htmlspecialchars(json_encode($tipo)) ?>)">
                                Editar
                            </button>
                            <!-- Botón para abrir el modal de eliminación -->
                            <button 
                                class="btn btn-danger btn-sm" 
                                onclick="openDeleteModal(<?= $tipo['id'] ?>)">
                                Eliminar
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Modal para Editar Tipo de Ticket -->
    <div class="modal fade" id="editTicketModal" tabindex="-1" aria-labelledby="editTicketModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editTicketForm" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editTicketModalLabel">Editar Tipo de Ticket</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="ticket_id" id="editTicketId">
                        <div class="mb-3">
                            <label for="editNombre" class="form-label">Nombre</label>
                            <input type="text" class="form-control" id="editNombre" name="nombre" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary" name="update_ticket_type">Guardar Cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal para Confirmar Eliminación -->
    <div class="modal fade" id="deleteTicketModal" tabindex="-1" aria-labelledby="deleteTicketModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="deleteTicketForm" method="GET">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteTicketModalLabel">Confirmar Eliminación</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>¿Estás seguro de que deseas eliminar este tipo de ticket?</p>
                        <input type="hidden" name="delete" id="deleteTicketId">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Eliminar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Abrir el modal de edición con los datos del tipo de ticket
        function openEditModal(ticket) {
            document.getElementById('editTicketId').value = ticket.id;
            document.getElementById('editNombre').value = ticket.nombre;
            new bootstrap.Modal(document.getElementById('editTicketModal')).show();
        }

        // Abrir el modal de eliminación con el ID del tipo de ticket
        function openDeleteModal(ticketId) {
            document.getElementById('deleteTicketId').value = ticketId;
            new bootstrap.Modal(document.getElementById('deleteTicketModal')).show();
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
